<?php
namespace Src\Lib;

final class Security {

  public static function appSecret(): string {
    return (string)($GLOBALS['APP_CONFIG']['app_secret'] ?? '');
  }

  public static function sha256(string $value): string {
    return hash('sha256', $value);
  }

  public static function hashIdentifier(string $value): string {
    $secret = self::appSecret();
    return hash('sha256', $secret . '|' . $value);
  }

  public static function getClientIp(): string {
    return $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
  }

  public static function getDeviceId(): string {
    $h = $_SERVER['HTTP_X_DEVICE_ID'] ?? '';
    return trim($h) !== '' ? trim($h) : 'unknown';
  }

  public static function bearerToken(): string {
    $auth = $_SERVER['HTTP_AUTHORIZATION'] ?? '';
    if (preg_match('/Bearer\s+(.*)$/i', $auth, $m)) return trim($m[1]);
    return '';
  }

  public static function signToken(string $payload): string {
    return hash_hmac('sha256', $payload, self::appSecret());
  }
}
