<?php
declare(strict_types=1);

spl_autoload_register(function ($class) {
  $prefix = 'Src\\';
  $base_dir = __DIR__ . '/';
  $len = strlen($prefix);
  if (strncmp($prefix, $class, $len) !== 0) return;
  $relative_class = substr($class, $len);
  $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';
  if (file_exists($file)) require $file;
});

$configPath = __DIR__ . '/../public/config.php';
if (!file_exists($configPath)) {
  http_response_code(500);
  header('Content-Type: application/json; charset=utf-8');
  echo json_encode(['ok' => false, 'error' => 'Missing config.php. Copy public/config.sample.php to public/config.php and edit credentials.']);
  exit;
}

$GLOBALS['APP_CONFIG'] = require $configPath;
