<?php
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');
header('X-Content-Type-Options: nosniff');

require_once __DIR__ . '/../src/bootstrap.php';

use Src\Controllers\ReportsController;
use Src\Controllers\AdminController;
use Src\Lib\Http;

$method = $_SERVER['REQUEST_METHOD'] ?? 'GET';
$uri = $_SERVER['REQUEST_URI'] ?? '/';
$path = parse_url($uri, PHP_URL_PATH) ?: '/';
$path = rtrim($path, '/');
if ($path === '') $path = '/';

try {
  if ($path === '/v1/health') {
    Http::ok(['ok' => true, 'time' => time()]);
  }

  if ($path === '/v1/reports' && $method === 'POST') {
    (new ReportsController())->createReport();
  }
  if ($path === '/v1/reports' && $method === 'GET') {
    (new ReportsController())->listReports();
  }

  if (preg_match('#^/v1/reports/(\d+)/photos$#', $path, $m) && $method === 'POST') {
    (new ReportsController())->uploadPhotos((int)$m[1]);
  }

  if (preg_match('#^/v1/reports/(\d+)/flags$#', $path, $m) && $method === 'POST') {
    (new ReportsController())->flagReport((int)$m[1]);
  }

  if ($path === '/v1/admin/login' && $method === 'POST') {
    (new AdminController())->login();
  }
  if (preg_match('#^/v1/admin/reports/(\d+)/(hide|remove)$#', $path, $m) && $method === 'POST') {
    (new AdminController())->moderate((int)$m[1], $m[2]);
  }

  Http::error(404, 'Not Found');

} catch (Throwable $e) {
  Http::error(500, 'Server error', ['detail' => $e->getMessage()]);
}
